
//Prelucrarea imaginilor - laboratorul nr. 9
//Mihai Ivanovici

#include "aplicatie.h"
#include <qimage.h>
#include <qmessagebox.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

//------------------------------------------------------------------------------

void ImageViewer :: write_naked_image( void )
{
    int	i, j;
    int	w, h;
    FILE	*file;
    
    w = image.width();
    h = image.height();
    
    file = fopen( "naked.img", "w" );
    if( file != NULL )
    {   
        for( i = 0; i < w; i++ )
	{
	    for( j = 0; j < h; j++ )
    	    {
		int niv = qRed( image.pixel( i, j ) );	//nivelul de gri al pixelului
	    
		fprintf( file, "%3d ", niv );
	    }
	    fprintf( file, "\n" );
	}

	fclose( file );

    }
    else
	QMessageBox :: about( this, "Laborator PI", "Eroare la deshiderea fisierului !" );
    
}


//------------------------------------------------------------------------------

void ImageViewer :: compresie_decompresie_cu_transformata_cosinus_discreta( void )
{
    int		w, h;
    int		i, j, k;
    double	pi = 3.1415926;
    
    w = image.width();
    h = image.height();
    
    if( w == h )
    {
	int	N = w;
	double  max;
	double	C[ N ][ N ];	//matricea transformarii cosinus
	double	U[ N ][ N ];	//matricea imaginii in spatiul original
	double	V[ N ][ N ];	//matricea imaginii in spatiul transformatei
	double  AUX[ N ][ N ];
    
	// COMPRESIA IMAGINII
    
	//formarea matricei C a transformarii cosinus discreta
	for( i = 0; i < N; i++ )
	    C[ 0 ][ i ] = 1. / sqrt( N );

	for( i = 1; i < N; i++ )
	    for( j = 0; j < N; j++ )
		C[ i ][ j ] = sqrt( 2./N ) * cos( pi * ( 2*j + 1 ) * i / ( 2*N ) );

	//formarea matricei U
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
		U[ i ][ j ] = qRed( image.pixel( i, j ));
		
	//V = C*U*Ct
	//mai intii vom calcula AUX = C * U
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		AUX[ i ][ j ] = 0;	
		for( k = 0; k < N; k++ )
		    AUX[ i ][ j ] += C[ i ][ k ] * U[ k ][ j ];
	    }	

	//apoi V = AUX * Ct
	max = 0;
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		V[ i ][ j ] = 0;	
		for( k = 0; k < N; k++ )
		    V[ i ][ j ] += AUX[ i ][ k ] * C[ j ][ k ];
	    
		if( V[ i ][ j ] > max )
		    max = V[ i ][ j ];
	    }	
	    
	QImage	transf( N, N, 32, 0, QImage::IgnoreEndian );
	
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		int niv = (int)( 255. * V[ i ][ j ] / max );
		transf.setPixel( i, j, qRgb( niv, niv, niv ) );
	    }

	//scrierea imaginii (in spatiul transformatei)
	QImageIO	iio;

	iio.setImage( transf );
	iio.setFileName( "transformata.bmp" );
	iio.setFormat( "BMP" );
	iio.write();

/*	//anularea coeficientilor, in vederea maririi factorului de compresie
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		if( V[ i ][ j ] < 100 )		//pragul de anulare
		    V[ i ][ j ] = 0;	

		//valori ale pragului de anulare: -500, -100, 0, 100, 500
	    }
*/	    
	// DECOMPRESIA IMAGINII
	
	//U = Ct * V * C
	//AUX = Ct * V
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		AUX[ i ][ j ] = 0;	
		for( k = 0; k < N; k++ )
		    AUX[ i ][ j ] += C[ k ][ i ] * V[ k ][ j ];
	    }	
	//apoi U = AUX * C
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		U[ i ][ j ] = 0;	
		for( k = 0; k < N; k++ )
		    U[ i ][ j ] += AUX[ i ][ k ] * C[ k ][ j ];
	    }	

	QImage	decomp( N, N, 32, 0, QImage::IgnoreEndian );

	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		int niv = (int) U[ i ][ j ];
		decomp.setPixel( i, j, qRgb( niv, niv, niv ));
	    }	
	
	//scrierea imaginii (in spatiul original)
	iio.setImage( decomp );
	iio.setFileName( "decompresata.bmp" );
	iio.setFormat( "BMP" );
	iio.write();

	//pseudo-imaginea diferenta
	
	QImage	diff( N, N, 32, 0, QImage:: IgnoreEndian );
	
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		int	dif = abs( qRed( image.pixel( i, j ) ) - (int)( U[ i ][ j ] ) );
		
		diff.setPixel( i, j, qRgb( dif, dif, dif ) );
	    }

	iio.setImage( diff );
	iio.setFileName( "diferenta.bmp" );
	iio.setFormat( "BMP" );
	iio.write();

    }
    else
	QMessageBox :: about( this, "Laborator PI", "Dimensiunile imaginii trebuie sa fie egale" );    

}

