
//Prelucrarea imaginilor - laboratorul nr. 8
//Mihai Ivanovici

#include "aplicatie.h"
#include <qimage.h>
#include <qmessagebox.h>
#include <math.h>

//------------------------------------------------------------------------------

void ImageViewer :: transformata_cosinus_discreta( void )
{
    int		w, h;
    int		i, j, k;
    double	pi = 3.1415926;
    
    w = image.width();
    h = image.height();
    
    if( w == h )
    {
	int	N = w;
	double max = 0;
	double	C[ N ][ N ];	//matricea transformarii cosinus
	int	U[ N ][ N ];	//matricea imaginii in spatiul original
	double	V[ N ][ N ];	//matricea imaginii in spatiul transformatei
	double  AUX[ N ][ N ];
    
	//formarea matricei C a transformarii cosinus discreta
	for( i = 0; i < N; i++ )
	    C[ 0 ][ i ] = 1. / sqrt( N );

	for( i = 1; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		C[ i ][ j ] = sqrt( 2./N ) * cos( pi * ( 2*j + 1 ) * i / ( 2*N ) );
		if( C[ i ][ j ] > max )
		    max = C[ i ][ j ];
	    }

	QImage	cosinus( N, N, 32, 0, QImage::IgnoreEndian );
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		int gri = (int)( C[ i ][ j ] * 255 / max );
		cosinus.setPixel( i, j, qRgb( gri, gri, gri ));
    	    }
	    
	QImageIO	iio;
	iio.setImage( cosinus );
	iio.setFileName( "cosinus.bmp" );
	iio.setFormat( "BMP" );
	iio.write();
	
	//formarea matricei U
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
		U[ i ][ j ] = qRed( image.pixel( i, j ));
		
	//V = C*U*Ct
	//mai intii vom calcula AUX = C * U
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		AUX[ i ][ j ] = 0;	
		for( k = 0; k < N; k++ )
		    AUX[ i ][ j ] += C[ i ][ k ] * U[ k ][ j ];
	    }	
	//apoi V = AUX * Ct
	max = 0;
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		V[ i ][ j ] = 0;	
		for( k = 0; k < N; k++ )
		    V[ i ][ j ] += AUX[ i ][ k ] * C[ j ][ k ];
	    
		if( V[ i ][ j ] > max )
		    max = V[ i ][ j ];
	    }	
	    
	QImage	transf( N, N, 32, 0, QImage::IgnoreEndian );
	
	int nr = 0;
	
	for( i = 0; i < N; i++ )
	    for( j = 0; j < N; j++ )
	    {
		int niv = (int)( V[ i ][ j ] * 255 / max );
		if( niv != 0 )
		    nr++;
		transf.setPixel( i, j, qRgb( niv, niv, niv ) );
	    }
	
	image = transf;
	pm = image;
	update();

	QString	m;
	m.sprintf( "Procentul de coeficienti diferiti de 0, in spatiul transformatei = %f", nr * 100. / ( N * N ) );
	QMessageBox :: about( this, "Laborator PI", m );
    }
    else
	QMessageBox :: about( this, "Laborator PI", "Dimensiunile imaginii trebuie sa fie egale" );    

}

