
//Prelucrarea imaginilor - laboratorul nr. 6
//Mihai Ivanovici

#include "aplicatie.h"
#include <qimage.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <stdlib.h>
#include <math.h>

//------------------------------------------------------------------------------
void ImageViewer :: mediere( void )
{
    int	i, j;
    int k, l;
    int w, h;
    
    double	v[ 3 ][ 3 ];

    //coeficientii mastii de filtrare
    v[ 0 ][ 0 ] = 1./9;    v[ 0 ][ 1 ] = 1./9;    v[ 0 ][ 2 ] = 1./9;
    v[ 1 ][ 0 ] = 1./9;    v[ 1 ][ 1 ] = 1./9;    v[ 1 ][ 2 ] = 1./9;
    v[ 2 ][ 0 ] = 1./9;    v[ 2 ][ 1 ] = 1./9;    v[ 2 ][ 2 ] = 1./9;
    
    w = image.width();
    h = image.height();

    QImage	image_fil( w, h, 32, 0, QImage::IgnoreEndian );
    
    for( i = 1; i < w - 1; i++ )
	for( j = 1; j < h - 1; j++ )
	{
	    //suma ponderata
	    double sum = 0;
	    
	    for( k = -1; k < 2; k++ )
		for( l = -1; l < 2; l++ )
		    sum += v[ k + 1 ][ l + 1 ] * qRed( image.pixel( i + k, j + l ));
	
	    image_fil.setPixel( i, j, qRgb( (int)sum, (int)sum, (int)sum ));	
	}
    
    image = image_fil;
    pm = image;
    update();	
}

void ImageViewer :: accentuare( void )
{
    int	i, j;
    int k, l;
    int w, h;

    double	sum;
    double	v[ 3 ][ 3 ];

    //coeficientii mastii 
    v[ 0 ][ 0 ] = 0;      v[ 0 ][ 1 ] = -1./4;    v[ 0 ][ 2 ] = 0;
    v[ 1 ][ 0 ] = -1./4;  v[ 1 ][ 1 ] = 1;        v[ 1 ][ 2 ] = -1./4;
    v[ 2 ][ 0 ] = 0;      v[ 2 ][ 1 ] = -1./4;    v[ 2 ][ 2 ] = 0;

    w = image.width();
    h = image.height();
    
    QImage	image_fil( w, h, 32, 0, QImage::IgnoreEndian );
    
    for( i = 1; i < w - 1; i++ )
	for( j = 1; j < h - 1; j++ )
	{
	    sum = 0;
	    
	    for( k = -1; k < 2; k++ )
		for( l = -1; l < 2; l++ )
		    sum += 1. * v[ k + 1 ][ l + 1 ] * qRed( image.pixel( i + k, j + l ));
	    
	    int niv = qRed( image.pixel( i, j )); 
	    niv = (int)( niv + 0.6 * sum );
	    image_fil.setPixel( i, j, qRgb( niv, niv, niv ));	
	}
    
    image = image_fil;
    pm = image;
    update();	

}

void ImageViewer :: median( void )
{
    int	i, j;
    int w, h;
    int	k, aux;
    int m, n;
    int med;
    int	sir[ 9 ];
    
    w = image.width();
    h = image.height();
    
    QImage	image_fil( w, h, 32, 0, QImage::IgnoreEndian );
    
    for( i = 1; i < w-1; i++ )
	for( j = 1; j < h-1; j++ )
	{
	    //formarea unui sir de 9 elemente din vecinatatea de 3x3
	    k = 0;
	    for( m = -1; m < 2; m++ )
		for( n = -1; n < 2; n++ )
		{
		    sir[ k ] = qRed( image.pixel( i + m, j + n ) );
		    k++;
		}
		
	    //ordonarea crescatoare a valorilor pixelilor
	    //metoda BUBBLE SORT	
	    k = 0;
	    while( k == 0 )
	    {
		k = 1;
		for( m = 0; m < 8; m++ )
		    if( sir[ m ] > sir[ m + 1 ] )
		    {
			aux = sir[ m ];
			sir[ m ] = sir[ m + 1 ];
			sir[ m + 1 ] = aux;
			k = 0;
		    }
	    }

	    //elementul median
	    med = sir[ 4 ];

	    //noua valoare a pixelului
	    image_fil.setPixel( i, j, qRgb( med, med, med ) );
	}

    image = image_fil;
    pm = image;
    update();
}


//------------------------------------------------------------------------------

void ImageViewer :: gaussian( void )
{
    int	i, j;
    
    int w = image.width();
    int h = image.height();

    long int	e_zgomot = 0;	//energia zgomotului
    long int	e_imagine = 0;	//energia imaginii

    double	SNR;	//raportul semnal-zgomot
        
    QImage	image_aff( w, h, 32, 0, QImage::IgnoreEndian );	//imaginea afectata de zgomot

    int	med = 0;	//media zgomotului
    int dis = 400;	//dispersia zgomotului
    
    for( i = 0; i < w; i++ )
	for( j = 0; j < h; j++ )
	{
	    QRgb pixel = image.pixel( i, j );
	    
	    int nivel_gri = qRed( pixel );
	    
	    e_imagine += nivel_gri * nivel_gri;
	    
	    //srand( rand() );
	    int zgomot = ( int )( med + sqrt( 2 )*sqrt( -1.* log( rand()/( RAND_MAX + 1. ) ) ) * cos( 2 * 3.1415926 * ( rand()/( RAND_MAX+1 ) ) )*sqrt( dis ) );
	    
	    e_zgomot += zgomot * zgomot;
	    
	    int val = nivel_gri + zgomot;
	    
	    if( val > 255 )
		val = 255;
	    if( val < 0 )
		val = 0;
		
	    image_aff.setPixel( i, j, qRgb( val, val, val ));
	}    

    SNR = 10 * log( 1. * e_imagine / e_zgomot );
    
    image = image_aff;
    pm = image;
    update();

    QString	mesaj;
    mesaj.sprintf( "SNR = %6.3lf dB", SNR );
    
    QMessageBox :: about( this, "Raportul Semnal-Zgomot", mesaj );

}

void ImageViewer :: salt_and_pepper( void )
{
    int	i, j;
    int	k;
    
    int w = image.width();
    int h = image.height();

    double	nr = 0.1;	//procentul de pixeli afectati de zgomot

    srand( rand() );
    
    k = 0;
    while( k < ( int )( w * h * nr ) )
    {
	i = ( int )( 1. * w * rand() / ( RAND_MAX + 1. ) );
	j = ( int )( 1. * h * rand() / ( RAND_MAX + 1. ) );
	
        QRgb	sare_piper;
		
	if( ( 100. * rand() / ( RAND_MAX + 1. ) ) >= 50 )
	    sare_piper = qRgb( 255, 255, 255 );
	else
	    sare_piper = qRgb( 0, 0, 0 );
	
	if( (i >= 0) && (i < w) && (j >= 0) && (j < h) )
	    image.setPixel( i, j, sare_piper );
	
	k++;
    }

    pm = image;
    update();
}

//------------------------------------------------------------------------------

