
//Prelucrarea imaginilor - laboratorul nr. 6
//Mihai Ivanovici

#include "aplicatie.h"
#include <qimage.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <stdlib.h>
#include <math.h>

//------------------------------------------------------------------------------

void ImageViewer :: uniform( void )
{
    int	i, j;
    
    int w = image.width();
    int h = image.height();

    long int	e_zgomot = 0;	//energia zgomotului
    long int	e_imagine = 0;	//energia imaginii

    double	SNR;	//raportul semnal-zgomot
        
    QImage	image_aff( w, h, 32, 0, QImage::IgnoreEndian );	//imaginea afectata de zgomot
    
    int	med = 0;	//media zgomotului
    int dis = 200;	//dispersia zgomotului
    
    for( i = 0; i < w; i++ )
	for( j = 0; j < h; j++ )
	{
	    QRgb pixel = image.pixel( i, j );
	    
	    int nivel_gri = qRed( pixel );
	    
	    e_imagine += nivel_gri * nivel_gri;
	    
	    //srand( rand() );
	    int zgomot = ( int )( med + sqrt( 3 )*( 2. * ( rand()/( RAND_MAX + 1. ) ) )*sqrt( dis ) );
	    
	    e_zgomot += zgomot * zgomot;
	    
	    int val = nivel_gri + zgomot;
	    
	    if( val > 255 )
		val = 255;
	    if( val < 0 )
		val = 0;
		
	    image_aff.setPixel( i, j, qRgb( val, val, val ));
	}    

    SNR = 10 * log( 1. * e_imagine / e_zgomot );
    
    image = image_aff;
    pm = image;
    update();

    QString	mesaj;
    mesaj.sprintf( "SNR = %6.3lf dB", SNR );
    
    QMessageBox :: about( this, "Raportul Semnal-Zgomot", mesaj );
}

void ImageViewer :: gaussian( void )
{
    int	i, j;
    
    int w = image.width();
    int h = image.height();

    long int	e_zgomot = 0;	//energia zgomotului
    long int	e_imagine = 0;	//energia imaginii

    double	SNR;	//raportul semnal-zgomot
        
    QImage	image_aff( w, h, 32, 0, QImage::IgnoreEndian );	//imaginea afectata de zgomot

    int	med = 0;	//media zgomotului
    int dis = 400;	//dispersia zgomotului
    
    for( i = 0; i < w; i++ )
	for( j = 0; j < h; j++ )
	{
	    QRgb pixel = image.pixel( i, j );
	    
	    int nivel_gri = qRed( pixel );
	    
	    e_imagine += nivel_gri * nivel_gri;
	    
	    //srand( rand() );
	    int zgomot = ( int )( med + sqrt( 2 )*sqrt( -1.* log( rand()/( RAND_MAX + 1. ) ) ) * cos( 2 * 3.1415926 * ( rand()/( RAND_MAX+1 ) ) )*sqrt( dis ) );
	    
	    e_zgomot += zgomot * zgomot;
	    
	    int val = nivel_gri + zgomot;
	    
	    if( val > 255 )
		val = 255;
	    if( val < 0 )
		val = 0;
		
	    image_aff.setPixel( i, j, qRgb( val, val, val ));
	}    

    SNR = 10 * log( 1. * e_imagine / e_zgomot );
    
    image = image_aff;
    pm = image;
    update();

    QString	mesaj;
    mesaj.sprintf( "SNR = %6.3lf dB", SNR );
    
    QMessageBox :: about( this, "Raportul Semnal-Zgomot", mesaj );

}

void ImageViewer :: salt_and_pepper( void )
{
    int	i, j;
    int	k;
    
    int w = image.width();
    int h = image.height();

    double	nr = 0.1;	//procentul de pixeli afectati de zgomot

    srand( rand() );
    
    k = 0;
    while( k < ( int )( w * h * nr ) )
    {
	i = ( int )( 1. * w * rand() / ( RAND_MAX + 1. ) );
	j = ( int )( 1. * h * rand() / ( RAND_MAX + 1. ) );
	
        QRgb	sare_piper;
		
	if( ( 100. * rand() / ( RAND_MAX + 1. ) ) >= 50 )
	    sare_piper = qRgb( 255, 255, 255 );
	else
	    sare_piper = qRgb( 0, 0, 0 );
	
	if( (i >= 0) && (i < w) && (j >= 0) && (j < h) )
	    image.setPixel( i, j, sare_piper );
	
	k++;
    }

    pm = image;
    update();
}

//------------------------------------------------------------------------------

