
//Prelucrarea imaginilor - laboratorul nr. 4
//Mihai Ivanovici

#include "aplicatie.h"
#include <qimage.h>
#include <qmessagebox.h>

//------------------------------------------------------------------------------

void ImageViewer :: histograma_imaginii( void )
{
    int		i, j;
    int		width, height;
    int		h[ 256 ]; 

    histograma = new HistoWidget();
    
    for( i = 0; i < 256; i++ )
	h[ i ] = 0;
    
    width = image.width();
    height = image.height();
    
    for( i = 0; i < width; i++ )
	for( j = 0; j < height; j++ )
	{
	    QRgb	pixel;
	    pixel = image.pixel( i, j );
	    
	    int nivel_gri = qRed( pixel );
	    h[ nivel_gri ]++ ;
	}
	
    for( i = 0; i < 256; i++ )	
	histograma->setValue( i, h[ i ] );
    
    histograma->setFixedWidth( 512 );
    histograma->setFixedHeight( 320 );
    histograma->setBackgroundColor( white );
    histograma->show();
}

//------------------------------------------------------------------------------

void ImageViewer :: egalizeaza_histograma( void )
{
    int		i, j;
    int		width, height;
    int		h[ 256 ]; 

    histograma = new HistoWidget();
    
    for( i = 0; i < 256; i++ )
	h[ i ] = 0;
    
    width = image.width();
    height = image.height();
    
    //calcularea histogramei imaginii
    for( i = 0; i < width; i++ )
	for( j = 0; j < height; j++ )
	{
	    QRgb	pixel;
	    pixel = image.pixel( i, j );
	    
	    int nivel_gri = qRed( pixel );
	    h[ nivel_gri ]++ ;
	}
	
    //calcularea histogramei cumulative
    double	hc[ 256 ];
    
    hc[ 0 ] = h[ 0 ];
    for( i = 1; i < 256; i++ )
	hc[ i ] = hc[ i - 1 ] + h[ i ];

    QImage	imag_eq( width, height, 32, 0, QImage :: IgnoreEndian );

    //egalizarea histogramei
    for( i = 0; i < width; i++ )
	for( j = 0; j < height; j++ )
	{
	    QRgb pixel = image.pixel( i, j );
	    
	    int nivel = qRed( pixel );
	    int nivel_nou = (int)( ( hc[ nivel ] - hc[ 0 ] ) * 255 / ( width*height - hc[ 0 ] ) );
	    
	    imag_eq.setPixel( i, j, qRgb( nivel_nou, nivel_nou, nivel_nou ) );
	}

    image = imag_eq;
    pm = image;
    update();

/*	
    QImageIO	iio;
    
    iio.setImage( imag_eq );
    iio.setFileName( "imag_eq.bmp" );
    iio.setFormat( "BMP" );
    iio.write();

    QMessageBox :: about( this, "Laborator PI", "Imaginea egalizata este\n\n imag_eq.bmp" );
*/
}

