
//Prelucrarea imaginilor - laboratorul nr. 3
//Mihai Ivanovici

#include "aplicatie.h"
#include <qimage.h>
#include <qmessagebox.h>

//------------------------------------------------------------------------------

int ImageViewer :: f_accentuare( int nivel_gri )
{
/*
    a = 80	Va = 20
    b = 170	Vb = 235
    
    alfa = 20 / 80 = 0.4
    beta = ( 235 - 20 ) / ( 170 - 80 ) = 215 / 90
    gama = ( 255 - 235 ) / ( 255 - 170 ) = 20 / 85
*/

    if( nivel_gri >= 0 && nivel_gri <= 80 ) 
	return	( int )( 0.4 * nivel_gri );

    if( nivel_gri > 80 && nivel_gri <= 170 )
	return	( int )( 215 / 90. * ( nivel_gri - 80 ) + 20 );
    
    if( nivel_gri > 170 && nivel_gri <= 255 )
	return	( int )( 20 / 85. * ( nivel_gri - 170 ) + 235 );

    return	nivel_gri;
}

//------------------------------------------------------------------------------

void ImageViewer :: accentueaza_contrastul( void )
{
    int		w, h;
    int		i, j;
    
    w = image.width();
    h = image.height();
    
    QImage	imag_acc( w, h, 32, 0, QImage :: IgnoreEndian );
    
    for( i = 0; i < w; i++ )
	for( j = 0; j < h; j++ )
	{
	    QRgb pixel = image.pixel( i, j );
	    
	    int gri_vechi = qRed( pixel );
	    int gri_nou = f_accentuare( gri_vechi );
	    
	    imag_acc.setPixel( i, j, qRgb( gri_nou, gri_nou, gri_nou ) );    
	}
    
    QImageIO	iio;

    iio.setImage( imag_acc );
    iio.setFileName( "imag_acc.bmp" );
    iio.setFormat( "BMP" );
    iio.write();
    
    QMessageBox :: about( this, "Laborator PI", "Imaginea cu contrastul accentuat este\n\n imag_acc.bmp" );
}

//------------------------------------------------------------------------------

void ImageViewer :: negativeaza_imaginea( void )
{
    int		w, h;
    int		i, j;
    
    w = image.width();
    h = image.height();
    
    QImage	imag_neg( w, h, 32, 0, QImage :: IgnoreEndian );
    
    for( i = 0; i < w; i++ )
	for( j = 0; j < h; j++ )
	{
	    QRgb pixel = image.pixel( i, j );
	    
	    int r = qRed( pixel );
	    int g = qGreen( pixel );
	    int b = qBlue( pixel );
	    
	    imag_neg.setPixel( i, j, qRgb( 255 - r, 255 - g, 255 - b ) );    
	}
    
    QImageIO	iio;

    iio.setImage( imag_neg );
    iio.setFileName( "imag_neg.bmp" );
    iio.setFormat( "BMP" );
    iio.write();
    
    QMessageBox :: about( this, "Laborator PI", "Imaginea negativa este\n\n imag_neg.bmp" );
}


