
//Mihai IVANOVICI
//Procesarea imaginilor folosind logica fuzzy
//lucrare de laborator

#include "aplicatie.h"
#include <math.h>

//------------------------------------------------------------------------------

void ImageViewer :: fuzzy( void )
{
    int	i, j, k, l, m, n, p;
    int	ww, hh;
    int	gri, niv, nivd;

    QRgb	pixel;
    QRgb	pixeld;

    QImage	fuz;
    fuz = image.copy();

	//cele 8 masti de tip compas
    int	M[ 8 ][ 3 ][ 3 ];	

	//matricea diferentelor 
    int	dif[ 3 ][ 3 ];	
    
	//matricea  miu( diferente )
    double	miu[ 3 ][ 3 ];	
    
	double	min, max;
    double	PEP_M[ 8 ];
    double	PEP;
    int		nr;
    

    M[ 0 ][ 0 ][ 0 ] =  1;	M[ 0 ][ 0 ][ 1 ] =  1;	M[ 0 ][ 0 ][ 2 ] =  1;	
    M[ 0 ][ 1 ][ 0 ] =  0;	M[ 0 ][ 1 ][ 1 ] =  0;	M[ 0 ][ 1 ][ 2 ] =  0;	
    M[ 0 ][ 2 ][ 0 ] = -1;	M[ 0 ][ 2 ][ 1 ] = -1;	M[ 0 ][ 2 ][ 2 ] = -1;	

    M[ 1 ][ 0 ][ 0 ] =  1;	M[ 1 ][ 0 ][ 1 ] =  1;	M[ 1 ][ 0 ][ 2 ] =  0;	
    M[ 1 ][ 1 ][ 0 ] =  1;	M[ 1 ][ 1 ][ 1 ] =  0;	M[ 1 ][ 1 ][ 2 ] = -1;	
    M[ 1 ][ 2 ][ 0 ] =  0;	M[ 1 ][ 2 ][ 1 ] = -1;	M[ 1 ][ 2 ][ 2 ] = -1;	

    M[ 2 ][ 0 ][ 0 ] =  1;	M[ 2 ][ 0 ][ 1 ] =  0;	M[ 2 ][ 0 ][ 2 ] = -1;	
    M[ 2 ][ 1 ][ 0 ] =  1;	M[ 2 ][ 1 ][ 1 ] =  0;	M[ 2 ][ 1 ][ 2 ] = -1;	
    M[ 2 ][ 2 ][ 0 ] =  1;	M[ 2 ][ 2 ][ 1 ] =  0;	M[ 2 ][ 2 ][ 2 ] = -1;	

    M[ 3 ][ 0 ][ 0 ] =  0;	M[ 3 ][ 0 ][ 1 ] = -1;	M[ 3 ][ 0 ][ 2 ] = -1;	
    M[ 3 ][ 1 ][ 0 ] =  1;	M[ 3 ][ 1 ][ 1 ] =  0;	M[ 3 ][ 1 ][ 2 ] = -1;	
    M[ 3 ][ 2 ][ 0 ] =  1;	M[ 3 ][ 2 ][ 1 ] =  1;	M[ 3 ][ 2 ][ 2 ] =  0;	

    M[ 4 ][ 0 ][ 0 ] = -1;	M[ 4 ][ 0 ][ 1 ] = -1;	M[ 4 ][ 0 ][ 2 ] = -1;	
    M[ 4 ][ 1 ][ 0 ] =  0;	M[ 4 ][ 1 ][ 1 ] =  0;	M[ 4 ][ 1 ][ 2 ] =  0;	
    M[ 4 ][ 2 ][ 0 ] =  1;	M[ 4 ][ 2 ][ 1 ] =  1;	M[ 4 ][ 2 ][ 2 ] =  1;	

    M[ 5 ][ 0 ][ 0 ] = -1;	M[ 5 ][ 0 ][ 1 ] = -1;	M[ 5 ][ 0 ][ 2 ] =  0;	
    M[ 5 ][ 1 ][ 0 ] = -1;	M[ 5 ][ 1 ][ 1 ] =  0;	M[ 5 ][ 1 ][ 2 ] =  1;	
    M[ 5 ][ 2 ][ 0 ] =  0;	M[ 5 ][ 2 ][ 1 ] =  1;	M[ 5 ][ 2 ][ 2 ] =  1;	

    M[ 6 ][ 0 ][ 0 ] = -1;	M[ 6 ][ 0 ][ 1 ] =  0;	M[ 6 ][ 0 ][ 2 ] =  1;	
    M[ 6 ][ 1 ][ 0 ] = -1;	M[ 6 ][ 1 ][ 1 ] =  0;	M[ 6 ][ 1 ][ 2 ] =  1;	
    M[ 6 ][ 2 ][ 0 ] = -1;	M[ 6 ][ 2 ][ 1 ] =  0;	M[ 6 ][ 2 ][ 2 ] =  1;	

    M[ 7 ][ 0 ][ 0 ] =  0;	M[ 7 ][ 0 ][ 1 ] =  1;	M[ 7 ][ 0 ][ 2 ] =  1;	
    M[ 7 ][ 1 ][ 0 ] = -1;	M[ 7 ][ 1 ][ 1 ] =  0;	M[ 7 ][ 1 ][ 2 ] =  1;	
    M[ 7 ][ 2 ][ 0 ] = -1;	M[ 7 ][ 2 ][ 1 ] = -1;	M[ 7 ][ 2 ][ 2 ] =  0;	

    ww = image.width();
    hh = image.height();
    
    for( i = 1; i < ww - 1 ; i++ )
	for ( j = 1; j < hh - 1; j++ )
	{
	    //pixelul curent = (i,j)
		pixel = image.pixel( i, j );
	    niv = qRed( pixel );
	    
	    //parcurge o vecinatate 3x3, pentru calculul diferentelor
	    for( k = -1; k < 2; k++ )
		for( l = -1; l < 2; l++ )
		{
		    pixeld = image.pixel( i + k, j + l );
		    nivd = qRed( pixeld );
		    
		    //calculeaza diferenta intre pixelul considerat si 
		    //pixelii din vecinatatea sa ( 3x3 )
		    dif[ k + 1 ][ l + 1 ] = ( int )( abs( niv - nivd ) );

		    //verifica daca pixelul considerat respecta vreuna din
		    //cele 8 reguli IF-THEN
		    //calculind astfel PEP
		    for( m = 0; m < 8; m++ )
		    {
			//pentru fiecare regula utilizeaza o masca compas
			nr = 0;
			min = 2;	//val > 1 (max)
			
			for( n = 0; n < 3; n++ )
			    for( p = 0; p < 3; p++ )
			    {
				switch( M[ m ][ n ][ p ] )
				{
				    case -1:
					{
					    miu[ n ][ p ] = miu_small( dif[ n ][ p ] );
					    break;
					}
				    case 0:
					{
					    miu[ n ][ p ] = 0;
					    break;
					}
				    case 1:
					{
					    miu[ n ][ p ] = miu_large( dif[ n ][ p ] );
					    break; 
					}   
				}
				
				//numara de cite ori Ds sau Dl sint 'small' respectiv 'large
				if( miu[ n ][ p ] != 0 )
				    nr++;
		    
				//determina miu_ cel mai mic
				if( miu[ n ][ p ] < min && miu[ n ][ p ] != 0 )
				    min = miu[ n ][ p ];
				        
			    }
			
			//daca toate Ds sint 'small' si toate Dl sint 'large'
			//adica in matricile 'val' si 'sat' sa avem 6 valori diferite de zero    
			if( nr == 6 )
			{
			    //pixelul considerat este un PEP 
			    PEP_M[ m ] = min;
			}
			else
			    PEP_M[ m ] = 0;
			
		    }
		    	
		    //calculeaza PEP ca maximul valorilor PEP_M
		    max = -1;

		    for( m = 0; m < 8; m++ )
			if( PEP_M[ m ]  > max )
			    max = PEP_M[ m ];

		    if( max != 0 )
			PEP = max;
		    else
			PEP = 0;
			
		}

	    gri = 255 - (int)( 255 * PEP );
	    fuz.setPixel( i, j, qRgb( gri, gri, gri ) );
	    
	}

    image = fuz;
    pm = image;
    update();
}

//------------------------------------------------------------------------------

double	ImageViewer :: miu_small( int x )
{
//functia de apartenenta la multimea valorilor 'small'

    if( x >= 0 && x <= 5 )
	return	1;
    if( x > 5 && x < 128 )
	return	1. * ( 128 - x ) / 123;
    
    return  0;
}


double	ImageViewer :: miu_large( int x )
{
//functia de apartenenta la multimea valorilor 'large'

    if( x > 128 && x <= 255 )
	return	1;
    if( x >= 5 && x <= 128 )
	return	1. * ( x - 5 ) / 123;
	
    return  0;
}

