
//Prelucrarea imaginilor - laboratorul nr. 10
//Mihai Ivanovici 

#ifndef APLICATIE_H
#define APLICATIE_H

#include <qwidget.h>
#include <qimage.h>
#include <qpainter.h>
#include <qlabel.h>

class QMenuBar;
class QPopupMenu;

class ImageViewer : public QWidget
{
    Q_OBJECT

    public:
	ImageViewer( QWidget *parent = 0 , const char *name = 0 , int wFlags = 0 );
        ~ImageViewer();
	bool	loadImage( const char *fileName );

    protected:
	void	paintEvent( QPaintEvent * );
	void	mouseMoveEvent( QMouseEvent * );

    private:
        int		conversion_flags;
        int		alloc_context;
        const char* 	filename;

        QImage		image;		
	QImage		back_up;
        QPixmap		pm;		

	QMenuBar    	*menubar;
        QPopupMenu  	*file;
	QPopupMenu	*algoritmi;
	QPopupMenu	*help;
	QLabel		*status;

	int		pix_x;
	int		pix_y;

	void		updateStatus();
	bool 		reconvertImage();
	bool		convertEvent( QMouseEvent*, int&, int& );

    private slots:
	void	openFile( void );
	void	saveFile( void );
	void	properties( void );
	void	about( void );

	void	extragere_contururi( void );
};

#endif // APLICATIE_H

