
//Prelucrarea imaginilor - laboratorul nr. 10
//Mihai Ivanovici

#include "aplicatie.h"
#include <qmenubar.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qpainter.h>
#include <qkeycode.h>
#include <qapplication.h>
#include <qwidget.h>

//------------------------------------------------------------------------------

ImageViewer :: ImageViewer( QWidget *parent , const char *name , int wFlags )
    : QWidget( parent , name , wFlags ) , conversion_flags( PreferDither ) , filename( 0 )
{
    alloc_context = 0;

    menubar = new QMenuBar( this );
    menubar->setSeparator( QMenuBar :: InWindowsStyle );

    file = new QPopupMenu();
    CHECK_PTR( file );
    menubar->insertItem( "&File" , file );
    file->insertItem( "Open image ( BMP )" , this , SLOT( openFile() ) , CTRL+Key_O );
    file->insertSeparator();
    file->insertItem( "Save as ... ( BMP )" , this , SLOT( saveFile() ) , CTRL+Key_S );
    file->insertSeparator();
    file->insertItem( "Image properties", this, SLOT( properties() ) );
    file->insertSeparator();
    file->insertItem( "Quit" , qApp ,  SLOT( quit() ) , CTRL+Key_Q );

    algoritmi = new QPopupMenu();
    CHECK_PTR( algoritmi );
    menubar->insertItem( "&Algoritmi", algoritmi );
    algoritmi->insertItem( "Segmentare prin extragere de contururi", this, SLOT( extragere_contururi() ) );

    help = new QPopupMenu();
    CHECK_PTR( help );
    menubar->insertItem( "&Help" , help );
    help->insertItem( "About..." , this , SLOT( about() ) , CTRL + Key_A );

    status = new QLabel( this );
    status->setFrameStyle( QFrame :: WinPanel | QFrame :: Sunken );
    status->setFixedHeight( fontMetrics().height() + 6 );

    setMouseTracking( TRUE );
}

//------------------------------------------------------------------------------

ImageViewer::~ImageViewer()
{
    if ( alloc_context )
    QColor :: destroyAllocContext( alloc_context );

    delete menubar;
    delete file;
    delete help;
    delete status;
}

//------------------------------------------------------------------------------

void ImageViewer :: about( void )
{
    QMessageBox :: about( this , "Aplicatie" , " Mihai IVANOVICI"
				 "\n Universitatea Politehnica Bucuresti"
				 "\n Prelucrarea imaginilor"
				 "\n Lucrare de laborator"  );    
}

//------------------------------------------------------------------------------

void ImageViewer  :: openFile()
{
    QString newfilename = QFileDialog :: getOpenFileName();

    if ( !newfilename.isEmpty() ) 
    {    
	loadImage( newfilename );
	repaint();	
    }
}


//------------------------------------------------------------------------------

void ImageViewer :: saveFile( void )
{
    QImageIO	iio;
    QString	save_as_file = QFileDialog :: getSaveFileName();

    if( !save_as_file.isEmpty() )
    {
	iio.setImage( image );
	iio.setFileName( save_as_file );
	iio.setFormat( "BMP" );
	iio.write();
    }
}


//------------------------------------------------------------------------------

bool ImageViewer :: loadImage( const char *fileName )
{
    filename = fileName;
    bool ok = FALSE;
    int	w, h ;

    if ( filename ) 
    {
	QApplication :: setOverrideCursor( waitCursor ); 
	ok = image.load( filename , 0 );

        pm.convertFromImage( image , conversion_flags );

	if( ok ) 
	{
	    setCaption( filename );	
	    w = pm.width();
	    h = pm.height();

	    h += menubar->heightForWidth(w) + status->height();
	} 
	else 
	{
	    pm.resize( 0 , 0 );			
	    update();
	}

	setFixedWidth( w );
	setFixedHeight( h );
        status->setGeometry( 0 , height() - status->height() , width() , status->height() );
	QApplication :: restoreOverrideCursor();	
    }

    back_up = image.copy();
    
    return ok;
}

//------------------------------------------------------------------------------

void ImageViewer :: paintEvent( QPaintEvent *e )
{
    if( pm.size() != QSize( 0, 0 ) ) 
    {		                      
	QPainter painter( this );
	painter.setClipRect( e->rect() );
	painter.drawPixmap( 0 , menubar->heightForWidth( width() ) , pm );
    }
}

//------------------------------------------------------------------------------

void ImageViewer :: properties( void )
{
    QString	prop;
    
    prop.sprintf( " Width = %d\n Height = %d\n Depth = %d\n numColors = %d\n", 
	image.width(), image.height(), image.depth(), image.numColors() );
	
    QMessageBox :: about( this, "Properties", prop );
}

//------------------------------------------------------------------------------

void ImageViewer :: updateStatus()
{
    int		r , g , b ;

    if ( pm.size() == QSize( 0, 0 ) ) 
	    status->setText("No image - select Open from File menu.");
    else 
    {
	QRgb		pixel;
	QString		message;

	if( image.valid( pix_x , pix_y ) )
	{
	    pixel = image.pixel( pix_x , pix_y );

	    r = qRed( pixel );
	    g = qGreen( pixel );
	    b = qBlue( pixel );
	    
	    message.sprintf( "(%3d,%3d) : ( R = %3d, G = %3d, B = %3d )" ,
			pix_x, pix_y, r , g , b  );
	}    

	status->setText( message );
    }
}

//------------------------------------------------------------------------------

bool ImageViewer :: convertEvent( QMouseEvent* e, int& x, int& y)
{
    if( pm.size() != QSize( 0, 0 ) ) 
    {
	int h = height() - menubar->heightForWidth( width() ) - status->height();
	int nx = e->x() * image.width() / width();
	int ny = ( e->y()-menubar->heightForWidth( width() ) ) * image.height() / h;
	if (nx != x || ny != y ) 
	{
	    x = nx;
	    y = ny;
	    updateStatus();
	    return TRUE;
	}
    }
    return FALSE;
}

//------------------------------------------------------------------------------

void ImageViewer :: mouseMoveEvent( QMouseEvent *e )
{
    if( convertEvent( e , pix_x , pix_y )) 
    {
	updateStatus();
    }
}

